#ifndef lint
static char *sccsid = "@(#) 2.5 src/somples.os2/somd/c/sompserv/somptest.c, somx, som2.0.fix, csd2.0.4 5/5/94 14:32:46 [5/23/94 10:10:29]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*-------------------------------------------------------------------------*
 * DSOM sample program.
 * --------------------
 *
 * SOMP Server object Driver program.
 *
 * When executed without parameters, this program creates four persistent
 * objects in the server process: one phoneDir object which contains three
 * dirEntry objects.
 *
 * The SOMPServer object used by this client application is built to
 * recognize persistent objects (derived from SOMPPersistentObject).
 * When this program requests that an object be created (via somdNewObject)
 * the server process recognizes it as a persistent object and initializes
 * it with a system assigned name.
 *
 * The SOMPServer class does not automatically store persistent objects.
 * This application must request the Persistent Storage Manager via the
 * somdGetStorageMgr method of the server. The objects can be stored with
 * the returned storage manager object.
 *
 * After the objects are stored, they are printed (shows up on the server)
 * and their DSOM ID's are displayed. The DSOM ID can be used to reference
 * the stored phoneDir (phonelist) object by calling this program again
 * with the ID.
 *
 *  ...
 *
 * When executed with the first parameter equal to the DSOM ID described
 * above, this program will result in the restoration of the phoneDir object
 * and its contained objects. When the SOMPServer class is asked to turn a
 * DSOM reference into an object it uses the ID passed to this program
 * to first restore the object.
 *
 *
 * Assumptions:
 * -----------
 * This program assumes that the server object specified for this program
 * is the SOMPServer class.
 *
 *
 * CHANGE HISTORY:
 * 04/22/93  cre  initial version
 *-------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

/* I N C L U D E S */
#include <somd.h>
int somdPrintf(char *,...);

#include <somp.h>            /*  Persistence Includes   */
#include <direntry.h>        /*  Client Class Includes  */
#include <phonedir.h>
#include <sompserv.h>        /* SOMP server object */


/* P R O T O T Y P E S */
int makeDSOMObject(char *, SOMObject *);
int initClasses(void);
int createObjects(void);
int freeObjects(void);
int displayObjectRefStrings(void);

/* E X T E R N S    &   G L O B A L S */
extern long SOMD_TraceLevel;
extern int SOM_TraceLevel;
extern int somdCommDebugFlag;
extern ORB SOMD_ORBObject;             /* ORB object */
extern SOMDObjectMgr SOMD_ObjectMgr;   /* DSOM object Mgr */

Environment *gEv;

/* Object pointers */
dirEntry name1, name2, name3;
phoneDir phonelist;
SOMPServer remoteSvr;

#ifdef __OS2__
#define RESTXMP "restxmp.cmd"
#else
#define RESTXMP "restxmp"
#endif

main(int argc, char *argv[])
{
    /* initialization */
    gEv = somGetGlobalEnvironment();
    SOMD_Init(gEv);
    initClasses();

    if (argc>1)
    {
       /* Arg 1 is assumed to be the ID of the remote phonelist object. */
       phonelist = _string_to_object(SOMD_ORBObject, gEv, argv[1]);

       if (!phonelist || gEv->_major != NO_EXCEPTION)
       {
	  somPrintf("Unsuccessful attempt to reference %s\n", argv[1]);
	  exit(-1);
       }
       else
       {
	  name1 = _getEntry(phonelist, "Roger");
	  name2 = _getEntry(phonelist, "Hari");
	  name3 = _getEntry(phonelist, "Charles");
       }
    }
    else
    {
       /* By default, create objects... */
       createObjects();
    }

    /* Display objects */
    displayObjects();

    /* Free local and server objects */
    freeObjects();

    SOMD_Uninit(gEv);
    somdPrintf("\nProgram Completed\n");
    exit(0);
}


/*-------------------------------------------------------------------------*
 * Create remote objects for use by this client application.               *
 *------------------------------------------------------------------------ */
int createObjects(void)
{
    SOMPPersistentStorageMgr remotePsm;
    FILE *restxmp;

    /* create remote objects */
    if (makeDSOMObject("phoneDir", &phonelist))
	exit(1);

    if (makeDSOMObject("dirEntry", &name1))
	exit(1);

    if (makeDSOMObject("dirEntry", &name2))
	exit(1);

    if (makeDSOMObject("dirEntry", &name3))
	exit(1);

    /* update remote objects */
    _mkEntry  (name1, "Roger", "555-5085");
    _addEntry (phonelist, name1);

    _mkEntry  (name2, "Hari", "555-5079");
    _addEntry (phonelist, name2);

    _mkEntry  (name3, "Charles", "555-5571");
    _addEntry (phonelist, name3);

    /* store remote objects */
    if (remoteSvr && gEv->_major == NO_EXCEPTION)
    {
       remotePsm = _getPStorageMgr(remoteSvr, gEv, phonelist);
       /* phonelist contains the other objects; when it is stored,
	  the other objects are stored too.                           */
       _sompStoreObject(remotePsm, gEv, phonelist);

       if (gEv->_major == NO_EXCEPTION)
       {
	  /* write out executable which can be used to run this
	     sample program to restore the phonelist object on
	     the server */
	  if ((restxmp = fopen(RESTXMP, "w"))!=NULL)
	  {
	     fprintf(restxmp, "somptest \"%s\"",
			_object_to_string(SOMD_ORBObject, gEv, phonelist));
	     fclose(restxmp);
	  }
	  else
	  {
	     somPrintf("Could not create restxmp file.\n");
	  }
       }
    }
}


/*-------------------------------------------------------------------------*
 * Display objects                                                         *
 *------------------------------------------------------------------------ */
int displayObjects(void)
{
    string name;
    string phone;

    _printDirInfo(phonelist); /* Prints on server */
    name = dirEntry__get_name(name1);
    phone = __get_phone(name1);
    somPrintf("name1 is: %s at %s\n", name, phone);
    ORBfree(name);
    ORBfree(phone);

    name = dirEntry__get_name(name2);
    phone = __get_phone(name2);
    somPrintf("name2 is: %s at %s\n", name, phone);
    ORBfree(name);
    ORBfree(phone);

    name = dirEntry__get_name(name3);
    phone = __get_phone(name3);
    somPrintf("name3 is: %s at %s\n", name, phone);
    ORBfree(name);
    ORBfree(phone);

    displayObjectRefStrings();
}


/*-------------------------------------------------------------------------*
 * Display object reference strings                                        *
 *------------------------------------------------------------------------ */
int displayObjectRefStrings(void)
{
    somPrintf("phonelist object ID is: %s\n",
	       _object_to_string(SOMD_ORBObject, gEv, phonelist));
    somPrintf("name1 object ID is: %s\n",
	       _object_to_string(SOMD_ORBObject, gEv, name1));
    somPrintf("name2 object ID is: %s\n",
	       _object_to_string(SOMD_ORBObject, gEv, name2));
    somPrintf("name3 object ID is: %s\n",
	       _object_to_string(SOMD_ORBObject, gEv, name3));
}


/*-------------------------------------------------------------------------*
 * Free the objects.                                                       *
 *                                                                         *
 * somFree will free both the local and remote object. This will not       *
 * delete the persistent object. To delete the object, use                 *
 * somdDestroyObject here in this client program.                          *
 * somdDestroyObject will invoke the somdDeleteObj method of the server    *
 * so that the server has an opportunity to clean up any references to     *
 * the object.                                                             *
 *------------------------------------------------------------------------ */
int freeObjects(void)
{
    _somFree(phonelist);
    _somFree(name1);
    _somFree(name2);
    _somFree(name3);
}


/*-------------------------------------------------------------------------*
 * Initialize classes used by this client application                      *
 *------------------------------------------------------------------------ */
int initClasses(void)
{
    /* The <object>NewClass invocation is optional and unnecessary
     * in the client program when the class object is created in the
     * SOMInitModule function that is invoked during DLL initialization.
     */
    SOMPServerNewClass(0, 0);
    SOMPPersistentStorageMgrNewClass(0, 0);
    dirEntryNewClass(0, 0);
    phoneDirNewClass(0, 0);
    remoteSvr = _somdFindAnyServerByClass(SOMD_ObjectMgr, gEv, "phoneDir");
}


/*-------------------------------------------------------------------------*
 * makeDSOMObject -- Find server and create object instance.               *
 *------------------------------------------------------------------------ */
int makeDSOMObject(char *aclass, SOMObject * aobject)
{
    /* Create an instance */
    *aobject = _somdCreateObj(remoteSvr, gEv, aclass, NULL);

    if (*aobject == NULL)
    {
	somdPrintf("_somdNewObject(%s) returned NULL\n", aclass);
	return (1);
    }

    return (0);
}

